**************************************************************************
*
* User-Toolset shell for Apple IIgs pixelMap2Rgn code
*
* David A. Lyons
* Apple II Developer Technical Support
*
* Developer Technical Support Apple II Sample Code
*
* v3.0    20-Apr-90 DAL
*
**************************************************************************
*
* How to build this thing:
*    asmiigs pixelmap2rgn.aii
*    asmiigs pmusertool.aii
*    linkiigs pmusertool.aii.obj pixelmap2rgn.aii.obj -o pixMapTool -t $ba
*
**************************************************************************
                    case on

Version             gequ $0100          ;v1.0

pmUserTool          start

*                   Import pixelMap2Rgn, newPort, killPort

ptrTable            dc i4'(ptrTableEnd-ptrTable)/4'
                    dc i4'fNoError-1'                       ;$01xx BootInit
                    dc i4'fNoError-1'                       ;$02xx StartUp
                    dc i4'fNoError-1'                       ;$03xx ShutDown
                    dc i4'fVersion-1'                       ;$04xx Version
                    dc i4'fNoError-1'                       ;$05xx Reset
                    dc i4'fStatus-1'                        ;$06xx Status
                    dc i4'fNoError-1'                       ;$07xx reserved
                    dc i4'fNoError-1'                       ;$08xx reserved
                    dc i4'fPixelMap2Rgn-1'                  ;$09xx pixelMap2Rgn
                    dc i4'fNewPort-1'                       ;$0Axx newPort
                    dc i4'fKillPort-1'                      ;$0Axx killPort
ptrTableEnd         ANOP
*
save6               lda >myStatus
                    beq notStarted
                    plx
                    pla
                    sta >temp
                    pla
                    sta >temp+2
                    pla
                    sta >temp+4
                    phx
                    rts

temp                ds 6

myStatus            ds 2

notStarted          pla                 ;discard return address
                    txa
                    xba
                    and #$FF00
                    ora #$8001
                    sec
                    rtl

fStartUp            lda #$FFFF
                    bra startStop

fShutDown           lda #$0000
startStop           sta >myStatus
fNoError            lda #0
                    clc
                    rtl

fVersion            lda #Version
                    sta 7,s
                    bra fNoError

fStatus             lda >myStatus
                    sta 7,s
                    bra fNoError

********************

fPixelMap2Rgn       jsr save6
                    jsl pixelMap2Rgn
                    bra restore6        

fNewPort            jsr save6
                    jsl newPort
                    bra restore6        

fKillPort           jsr save6
                    jsl killPort

restore6            tay                 ;This is here so everybody
                    lda >temp+4         ;can reach it.
                    pha
                    lda >temp+2
                    pha
                    lda >temp
                    pha
                    tya
                    rtl

                    end

                    END
